#ifndef QRFEPIPE_H
#define QRFEPIPE_H

#include <QIODevice>

#include <QrfeFifo>

class QrfePipe : public QIODevice
{
    Q_OBJECT
public:
	QrfePipe(QObject *parent = 0);
	QrfePipe(QString name, QObject *parent = 0);
	virtual ~QrfePipe();

	bool			connectToPipe ( QrfePipe* pipe );

	QString			name () const;
	bool			isConnected () const;

	virtual void	close ();
	virtual qint64	bytesAvailable () const;

signals:
	void			connected ();
	void			disconnected ();

protected:
	virtual qint64	readData ( char * data, qint64 maxSize );
	virtual qint64	writeData ( const char * data, qint64 maxSize );

private slots:
	void			remoteConnect ( );
	void			remoteDisconnect ( );

private:
	QString 	m_name;
	QrfeFifo	m_inputBuffer;
	QrfePipe*	m_otherPipe;
};

#endif // QRFEPIPE_H
